/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import djbuch.kapitel_19.Newsletter;
import lotus.domino.AgentBase;
import lotus.domino.AgentContext;
import lotus.domino.NotesException;
import lotus.domino.Session;

/**
 * 
 * Beispielcode fr einen Java Agenten als Rumpf zum Start einer Businesslogik 
 * 
 * @author Thomas Ekert
 */
public class NewsletterAgent extends AgentBase {

	public void NotesMain() {

		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			Newsletter nl = new Newsletter (agentContext);
			int count = nl.send();
			System.out.println("Anzahl der versendeten NL: "
				+ (count == Newsletter.SEND_ERROR 
					? "FEHLER!" 
					: "" + count));
		} catch(NotesException e) {
			System.out.println ("id = " + e.id);
			e.printStackTrace();
		}
	}
}
